
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1317.C - Message 1317 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1317 messages.
//
//
//   REVISION HISTORY
//
//
//	  $Log:   V:\Projects\Labmon\Source\Archives\MSG1317.C_V  $
//   
//      Rev 1.15   09 Nov 1998 10:48:06   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.1   Jul 09 1997 10:54:52   COLEJ
//    
//   
//      Rev 1.0   25 Feb 1997 15:10:58   wladmin
//   Initial checking
//
////////////////////////////////////////////////////////////////////////////////

#include <string.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"   

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1317 message from the ZMsgBuf.
//
void Dec1317(tMSGBUF *ZMsgBuf, tMSG1317 *Msg)
{
	;  
}

////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1317 message in the ZMsgBuf. 
//
void Bld1317(tMSGBUF *ZMsgBuf, tMSG1317 *Msg)
{
   // copy message into buffer
   memcpy(((tSHORT *) ZMsgBuf)+5, Msg, sizeof(*Msg));          

   // build the header in the buffer
   PutShort  (0x81FF                  , ZMsgBuf, 1);    // message preamble
   PutShort  (1317                    , ZMsgBuf, 2);    // message number
   PutShort  (2                       , ZMsgBuf, 3);    // message length
   PutShort  (ANREQ                   , ZMsgBuf, 4);    // message ack/nack request
   
   // put duty cycle into message
   PutShort  (Msg->DutyCycle          , ZMsgBuf, 7);    // duty cycle
   
}
